/* ============ */
/* SetMaxT.c	*/
/* ============ */
#include <defcodes.h>
#include <maxtdefs.h>
#include <miscdefs.h>

#define	ACT(X)	#X

#define	CLAMP(Out, Var, Lo, Hi)	Out = __min(Hi, __max(Lo, Var))

#define	NEED_ALL(Label)	"Enter "Label

#define	NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define	LEN_LABEL   "Length of Each Sequence"
#define	SQNCE_LABEL "Number of Sequences"

#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL); printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetMaxOfTControls - Puts Run Controls in MaxtData structure		*/
/* ==================================================================== */
void
SetMaxOfTControls(MAXT_DATA_STRU *MaxtData)
{
    int     NewlineCh;
    UINT    UserUintEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    /* ----------------------------------------------------------- */
    /* Get Number of Sequences to be Used in Maximum-of-t Analysis */
    /* ----------------------------------------------------------- */
    GetUint(NEED_USER_ENTRY(SQNCE_LABEL, MIN_NUM_SQNCE, MAX_NUM_SQNCE),
	&UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, SQNCE_LABEL);

    CLAMP(MaxtData->NumSequences, UserUintEntry,
	(UINT)MIN_NUM_SQNCE, (UINT)MAX_NUM_SQNCE);

    SHOW_INT_VALUE_USED(UserUintEntry, MaxtData->NumSequences);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
    /* --------------------------------------- */
    /* Get Number of Variates in Each Sequence */
    /* --------------------------------------- */
    GetUint(NEED_USER_ENTRY(LEN_LABEL, MIN_SQNCE_LEN, MAX_SQNCE_LEN),
	&UserUintEntry);

    REPORT_USER_INT_ENTRY(UserUintEntry, LEN_LABEL);

    CLAMP(MaxtData->SequenceLen, (int)UserUintEntry,
	MIN_SQNCE_LEN, MAX_SQNCE_LEN);

    SHOW_INT_VALUE_USED(UserUintEntry, MaxtData->SequenceLen);

    fflush(NULL);fprintf(stderr, "%c", NewlineCh);
}
